#!/bin/bash

# Install_HLSP_Support.sh - Revision 1 by Rafael "R4to0" Maciel
echo "Valve Half-Life Single Player support for Sven Co-op"
echo "Based on original HLSP batch file by SC Team"
echo ""
echo "Warning: This script and ripent needs to be in svencoop"
echo "folder or will not work!"
echo ""

# Variables
RIPENT=./ripent-linux-m32

check_dependencies () {
	echo "Checking for dependencies..."
	echo ""
	if [ ! -f $RIPENT ]
		then
			echo "Ripent for linux is missing."
			echo "Make sure you have ripent for linux in svencoop directory."
			echo ""
			echo "This script is now exiting."
			exit 1
	else
		echo "Ripent found."
		chmod +x $RIPENT
		echo ""
	fi
	command -v unzip >/dev/null 2>&1  || { 
			echo "Unzip is not installed."
			echo "You can install using 'apt-get install unzip"
			echo "on Ubuntu and Debian, and 'yum install unzip'"
			echo "on Redhat or CentOS."
			exit 1
	}
	echo "Unzip found."
	echo ""
}

copy_hlspmaps () {
	echo "Copying around 150mb of HLSP maps in valve/maps"
	echo "folder to svencoop/maps folder."
	echo "May take a while, please wait..."
	cp ../valve/maps/c0a*.bsp maps/
	cp ../valve/maps/c1a*.bsp maps/
	cp ../valve/maps/c2a*.bsp maps/
	cp ../valve/maps/c3a*.bsp maps/
	cp ../valve/maps/c4a*.bsp maps/
	cp ../valve/maps/c5a*.bsp maps/
	cp maps/c1a4i.bsp maps/c1a4z.bsp
	cp maps/c1a2b.bsp maps/c1a2e.bsp
	cp maps/c2a4e.bsp maps/c2a4h.bsp
	cp maps/c1a3.bsp maps/c1a3e.bsp
	echo "Done!"
	echo ""
}

run_ripent() {
	echo "Unzipping ent files..."
	unzip -o hlsp_support.sven -d maps > /dev/null
	echo "Applying ripent..."
		for hlsp in maps/c0a*.bsp maps/c1a*.bsp maps/c2a*.bsp maps/c3a*.bsp maps/c4a*.bsp maps/c5a*.bsp
		do
		$RIPENT -import $hlsp > /dev/null
		done
}

rem_entfiles (){
	echo "Removing ent files"
	rm maps/c0a*.ent
	rm maps/c1a*.ent
	rm maps/c2a*.ent
	rm maps/c3a*.ent
	rm maps/c4a*.ent
	rm maps/c5a*.ent
	echo ""
}

runall () {
# dependencies checking
	check_dependencies
# hlsp maps coyping
	copy_hlspmaps
# run ripent
	run_ripent
#remove ent files
	rem_entfiles
}

# time to kickass!
runall

echo "All done!"
echo "HLSP Support installed sucessfully!"
echo ""
echo "This script is now exiting."
sleep 3
exit 0
